unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, TntStdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    ComboBox1: TComboBox;
    Label1: TLabel;
    Timer1: TTimer;
    OpenDialog1: TOpenDialog;
    TrackBar1: TTrackBar;
    Label2: TLabel;
    TrackBar2: TTrackBar;
    Label3: TLabel;
    TntLabel1: TTntLabel;
    TrackBar3: TTrackBar;
    TrackBar4: TTrackBar;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure TrackBar3Change(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
uses Bass, BassVideo;
var hEffect : integer;
    c1, c2 : DWORD;

procedure TForm1.FormCreate(Sender: TObject);
begin
 Bass_Init(-1, 44100, 0, 0, nil);
 hEffect := BassVideo_VMR9Effect_Create(Form1.Panel1.Handle);
 if hEffect = 0 then
  begin
   showmessage('VMR9 Error or BassVideo_VMR9.dll not found!');
   Application.Terminate;
  end;
 c1 := 0;
 c2 := 0;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
 BassVideo_VMR9Effect_Free(hEffect);
 BassVideo_Free;
 Bass_Free;
end;

procedure TForm1.Button1Click(Sender: TObject);
var R: TRect;
begin
 if not OpenDialog1.Execute then exit;
 // this example allow only two file
 // for simple, easy control
 // but you can add more :)
 if combobox1.Items.Count > 1 then exit;
 if c1 = 0 then
  begin
   c1 := BassVideo_VMR9Effect_AddFileEx(hEffect, PChar(OpenDialog1.FileName), 0, nil, nil);
   if c1 = 0 then
    showmessage('cannot add! check codec installed')
   else
    begin
     R := Form1.Panel1.ClientRect;
     BassVideo_SetVideoWindow(c1, Form1.Panel1.Handle, R, 0);
     BassVideo_WindowResize(c1, R, 0);
     Combobox1.Items.Add(OpenDialog1.FileName);
     Combobox1.ItemIndex := 0;
     BassVideo_Play(c1);
    end;
  end
 else
  begin
   c2 := BassVideo_VMR9Effect_AddFileEx(hEffect, PChar(OpenDialog1.FileName), 0, nil, nil);
   if c2 = 0 then
    showmessage('cannot add! check codec installed')
   else
    begin
     R := Form1.Panel1.ClientRect;
     R.Right := R.Right div 2;
     R.Bottom := R.Bottom div 2;
     BassVideo_SetVideoWindow(c2, Form1.Panel1.Handle, R, 0);
     BassVideo_WindowResize(c2, R, 0);
     Combobox1.Items.Add(OpenDialog1.FileName);
     BassVideo_Play(c2);
    end;
  end;

end;

procedure TForm1.Button3Click(Sender: TObject);
begin
 case combobox1.ItemIndex of
  0 : BassVideo_Play(c1);
  1 : BassVideo_Play(c2);
 end;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
 case Combobox1.ItemIndex of
  0 : BassVideo_Stop(c1);
  1 : BassVideo_Stop(c2);
 end;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
 case Combobox1.ItemIndex of
  0 : BassVideo_Pause(c1);
  1 : BassVideo_Pause(c2);
 end;

end;

procedure TForm1.TrackBar1Change(Sender: TObject);
var R: TRect;
begin
 R := Form1.Panel1.ClientRect;
 case combobox1.ItemIndex of
  0 : begin
        R.Left := Trackbar1.Position;
        R.Top := Trackbar2.Position;
        R.Right := R.Left + Panel1.Width;
        R.Bottom := R.Top + Panel1.Height;
        BassVideo_WindowResize(c1, R, 0);
      end;
  1 : begin
        R.Left := Trackbar1.Position;
        R.Top := Trackbar2.Position;
        R.Right := R.Left +  Panel1.Width div 2;
        R.Bottom := R.Top + Panel1.Height div 2;
        BassVideo_WindowResize(c2, R, 0);
      end;
  end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var c, l : Double;
begin
 case Combobox1.ItemIndex of
  0 : begin
       l := BassVideo_GetLength(c1);
       TrackBar4.Max := Round(l);
       c := BassVideo_GetPosition(c1);
       TrackBar4.Position := Round(c);
      end;
  1 : begin
       l := BassVideo_GetLength(c2);
       TrackBar4.Max := Round(l);
       c := BassVideo_GetPosition(c2);
       TrackBar4.Position := Round(c);
      end;
 else exit;
 end;
 Label1.Caption := FloatToStr(c) + ' / ' + inttostr(Round(l));
end;

procedure TForm1.TrackBar3Change(Sender: TObject);
begin
 case combobox1.ItemIndex of
  0 : BassVideo_VMR9Effect_SetInfo(hEffect, c1, BASSVIDEO_VMR9_ALPHA, Trackbar3.Position);
  1 : BassVideo_VMR9Effect_SetInfo(hEffect, c2, BASSVIDEO_VMR9_ALPHA, Trackbar3.Position);
 end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 case combobox1.ItemIndex of
  0 : begin
       BassVideo.BassVideo_VMR9Effect_Remove(hEffect, c1);
       c1 := c2;
       c2 := 0;
       Combobox1.Items.Delete(0);
      end;
  1 : begin
       BassVideo.BassVideo_VMR9Effect_Remove(hEffect, c2);
       c2 := 0;
       Combobox1.Items.Delete(1);
      end;
 end;
end;

end.
